///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//  Copyright  NetworkDLS 2002, All rights reserved
//
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF 
// ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
// THE IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A 
// PARTICULAR PURPOSE.
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifndef _CONSOLEPROCS_CPP
#define _CONSOLEPROCS_CPP
///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <Windows.H>
#include <StdIO.H>
#include <STDLib.H>
#include <PSAPI.H>
#include <SQL.H>

#include "../../SharedSource/Debug.H"
#include "../../SharedSource/NSWFL.H"
#include "../../SharedSource/Common.H"

#include "../../SharedClasses/CMemPool/CMemPool.H"

#include "../Resources/Resource.H"

#include "Entry.H"
#include "Init.H"
#include "WinService.H"
#include "Routines.H"
#include "Console.H"
#include "Console.H"
#include "ConsoleProcs.H"

#include "../../SharedClasses/CMemPool/CMemPool.H"

#include "../CSockSrvr/CSockSrvr.H"

#include "../Dialogs/MainDlg.H"
#include "../Dialogs/AlertDlg.H"

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ConsoleSysStats(void)
{
	char sText[255];
	char sInt[64];

	PROCESS_MEMORY_COUNTERS MyPMC;

	HANDLE hProcess = GetCurrentProcess();

	memset(&MyPMC, 0, sizeof(MyPMC));

    if(!GetProcessMemoryInfo(hProcess, &MyPMC, sizeof(MyPMC)))
	{
		return false;
	}

	FormatInteger(sInt, MyPMC.PageFaultCount);
	sprintf_s(sText, sizeof(sText), "Page Faults: %s\n", sInt);
	WriteCon(sText);

	FormatInteger(sInt, MyPMC.WorkingSetSize / 1024);
	sprintf_s(sText, sizeof(sText), "Memory Used: %sKB\n", sInt);
	WriteCon(sText);

	FormatInteger(sInt, MyPMC.QuotaPagedPoolUsage / 1024);
	sprintf_s(sText, sizeof(sText), "Paged Pool Usage: %sKB\n", sInt);
	WriteCon(sText);

	FormatInteger(sInt, MyPMC.QuotaPeakNonPagedPoolUsage / 1024);
	sprintf_s(sText, sizeof(sText), "Non-Paged Pool Usage: %sKB\n", sInt);
	WriteCon(sText);

	FormatInteger(sInt, MyPMC.PagefileUsage / 1024);
	sprintf_s(sText, sizeof(sText), "Page File Usage: %sKB\n", sInt);
	WriteCon(sText);

	FormatInteger(sInt, MyPMC.PeakWorkingSetSize / 1024);
	sprintf_s(sText, sizeof(sText), "Peak Memory Usage: %sKB\n", sInt);
	WriteCon(sText);

	FormatInteger(sInt, MyPMC.QuotaPeakPagedPoolUsage / 1024);
	sprintf_s(sText, sizeof(sText), "Peak Paged Pool Usage: %sKB\n", sInt);
	WriteCon(sText);

	FormatInteger(sInt, MyPMC.QuotaPeakNonPagedPoolUsage / 1024);
	sprintf_s(sText, sizeof(sText), "Peak Non-Paged Pool Usage: %sKB\n", sInt);
	WriteCon(sText);

	FormatInteger(sInt, MyPMC.PeakPagefileUsage / 1024);
	sprintf_s(sText, sizeof(sText), "Peak Page File Usage: %sKB\n", sInt);
	WriteCon(sText);

	//CloseHandle() IS NOT necessary because GetCurrentProcess()
	//	retrieves a pseudo handle for the current process.
	//CloseHandle(hProcess); 

	return true;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool DumpSQLStatsToConsole(HSTMT hStmt)
{
    return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool DumpSQLResultsToConsole(HSTMT hStmt)
{
    return 0;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

bool ConsoleConnect(void)
{
	return false;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void TestAlertDlg(const char *sText)
{
	StartAlertDlg("Test", sText, true);
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#ifdef _DEBUG_MEMPOOL
	void PrintMemMap(void)
	{
		int iSlot = 0;
		int iAlloc = 0;

		char sText[1024];
		
		WriteCon("-----------------------------------------------------\n");
		WriteCon("Allocated Memory Map:\n\n");
		sprintf_s(sText, sizeof(sText), "Allocations %d of %d.\n", 
			gMem.GetMemAllocationCount(), gMem.GetSlotAllocationCount());
		WriteCon(sText);

		//Free all the memory stored in the AllocPool structure.
		while(iSlot < gMem.UserAlloc.iAllocated)
		{
			if(gMem.UserAlloc.AllocPool[iSlot].bFree == false)
			{
				sprintf_s(sText, sizeof(sText), "Allocation: %d, Slot: %d, Address: 0x%X\n",
					iAlloc++, iSlot, gMem.UserAlloc.AllocPool[iSlot].iAddress);
				WriteCon(sText);
			}
			iSlot++;
		}

		WriteCon("-----------------------------------------------------\n");
	}
#endif

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD ProcessConsoleCoreCommand(char *sCommand)
{
	char TempText[1024];

    if(_strcmpi(sCommand, "help") == 0)
    {
        WriteCon(" Version\t Displays version info.\n");
        WriteCon(" Cls\t\t Clears the screen.\n");
        WriteCon(" Connections\t Displays conections info.\n");
        //WriteCon(" Connect\t Connects to a database and execute commands.\n");
        WriteCon(" Exit\t\t Closes the console.\n");
        WriteCon(" Start\t\t Starts the server.\n");
        WriteCon(" Stop\t\t Stoppes the server.\n");
        WriteCon(" KillAll\t Kills all current connections.\n");
        WriteCon(" FlushIO\t Flushes all IO streams to disk.\n");
        WriteCon(" ReadRegistry\t Re-Reads all registry values.\n");
        WriteCon(" WriteRegistry\t Writes all registry values.\n");
        WriteCon(" PauseTCP\t Pauses the TCPLoop thread.\n");
        WriteCon(" ResumeTCP\t Resumes the TCPLoop thread.\n");
        WriteCon(" Accept:ON\t Accepts incomming connections.\n");
        WriteCon(" Accept:OFF\t Rejects incomming connections.\n");
		#ifdef _DEBUG_MEMPOOL
			WriteCon(" MemMap\t\t Prints the allocation tables.\n");
		#endif
		return CONSOLE_CORE_RES_OK;
    }
	#ifdef _DEBUG_MEMPOOL
		else if(_strcmpi(sCommand, "MemMap") == 0)
		{
			PrintMemMap();
			return CONSOLE_CORE_RES_OK;
		}
	#endif
	else if(_strcmpi(sCommand, "cls") == 0)
    {
        system("cls");
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "SysStats") == 0)
    {
        if(!ConsoleSysStats())
		{
			WriteCon("ConsoleSysStats failed.\n");
		}
        return CONSOLE_CORE_RES_OK;
    }
	else if(_strcmpi(sCommand, "accept:on") == 0)
    {
        //gbAcceptConnections = true;
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "accept:off") == 0)
    {
        //gbAcceptConnections = false;
        return CONSOLE_CORE_RES_OK;
    }
/*
	//FIXME: Need to reimplement the pause resume tcp thread feature.

	else if(_strcmpi(sCommand, "pausetcp") == 0)
    {
        if(gServer.Pause_TCPHandler())
            WriteCon("TCPLoop paused.");
        else WriteCon("Error pausing TCPLoop.");
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "resumetcp") == 0)
    {
        if(gServer.Resume_TCPHandler())
            WriteCon("TCPLoop resumed.");
        else WriteCon("Error resuming TCPLoop.");
        return CONSOLE_CORE_RES_OK;
    }
*/
    else if(_strcmpi(sCommand, "readregistry") == 0)
    {
		//FIXME: Need to reimplement the pause resume tcp thread feature.
		//gServer.Pause_TCPHandler();
        if(GetRegistryValues())
            WriteCon("Registry vlaues re-read.");
        else WriteCon("Error reading registry values.");
        //gServer.Resume_TCPHandler();
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "writeregistry") == 0)
    {
		//FIXME: Need to reimplement the pause resume tcp thread feature.
        //gServer.Pause_TCPHandler();
        if(SaveRegistryValues())
            WriteCon("Registry vlaues written.");
        else WriteCon("Error writing registry values.");
        //gServer.Resume_TCPHandler();
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "flushio") == 0)
    {
        sprintf_s(TempText, sizeof(TempText), "Flushed %d IO streames to disk.\n", _flushall());
		WriteCon(TempText);
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "killall") == 0)
    {
        DWORD dwDisconnects = 0;
        DWORD dwCount = 0;

        while(dwCount < gdwMaxClients)
        {
            if(gServer.bcConnected[dwCount] = true)
			{
                dwDisconnects++;
			}
			dwCount++;
        }

        sprintf_s(TempText, sizeof(TempText), "Disconnected %d clients.\n", dwDisconnects);
        WriteCon(TempText);
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "start") == 0)
    {
        if(StartServer())
            WriteCon("Server started.\n");
        else WriteCon("Failed to start the server.\n");
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "stop") == 0)
    {
        if(StopServer())
            WriteCon("Server stopped.\n");
        else WriteCon("Failed to stop the server.\n");
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "version") == 0)
    {
        sprintf_s(TempText, sizeof(TempText),
			"%s - [Version: %s] (Built: %s at %s)\n", gsTitleCaption, gsFileVersion, __DATE__, __TIME__);
        WriteCon(TempText);
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "connections") == 0)
    {
        sprintf_s(TempText, sizeof(TempText), 
			"Class: %d, Total: %d\n", gServer.GetCurrentClients(), gdwTotalConnects);
        WriteCon(TempText);
        return CONSOLE_CORE_RES_OK;
    }
	else if(_strnicmp(sCommand, "Alert ", 6) == 0)
	{
		TestAlertDlg(sCommand + 6);
	}
	else if(_strcmpi(sCommand, "Connect") == 0)
    {
        ConsoleConnect();
        return CONSOLE_CORE_RES_OK;
    }
    else if(_strcmpi(sCommand, "exit") == 0)
    {
        return CONSOLE_CORE_RES_CLOSE;
    }
    else{
        sprintf_s(TempText, sizeof(TempText), "Unknown command: '%s'.\n", sCommand);
        WriteCon(TempText);
        return CONSOLE_CORE_RES_UNKNOWN;
    }

    return CONSOLE_CORE_RES_ERROR;
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif
